/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed*0.3
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.
//
// With VGHD if no other texture has been selected by the .scn file iChannel0
// will pick up the performer or the performers name sprite.

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

#define PI	3.14159265359

bool Flag = false;
int material;
vec3 objCol;

mat2 rotate(float a)
{
	return mat2(cos(a), sin(a), -sin(a), cos(a));	
}

vec3 hsv(float h, float s, float v)
{
  return mix( vec3( 1.0 ), clamp( ( abs( fract(
    h + vec3( 3.0, 2.0, 1.0 ) / 3.0 ) * 6.0 - 3.0 ) - 1.0 ), 0.0, 1.0 ), s ) * v;
}

// https://www.shadertoy.com/view/MtsGWH
vec4 boxmap(sampler2D sam, in vec3 p, in vec3 n)
{
    vec3 m = pow(abs(n), vec3(8.0));
	vec4 x = texture2D(sam, p.yz);
	vec4 y = texture2D(sam, p.zx);
	vec4 z = texture2D(sam, p.xy);
	return (x*m.x + y*m.y + z*m.z)/(m.x+m.y+m.z);
}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

// https://www.shadertoy.com/view/4tX3DS
vec2 fold2(in vec2 p, in float a)
{
    p.x = abs(p.x);
    vec2 v = vec2(cos(a), sin(a));
    for(int i = 0; i < 2; i++)
    {	
    	p -= 2.0 * min(0.0, dot(p, v)) * v;
    	v = normalize(vec2(v.x - 1.0, v.y));
    }
 	return p;    
}

vec2 fold3(in vec2 p, in float a)
{
    p.x = abs(p.x);
    vec2 v = vec2(cos(a), sin(a));
    for(int i = 0; i < 3; i++)
    {	
    	p -= 2.0 * min(0.0, dot(p, v)) * v;
    	v = normalize(vec2(v.x - 1.0, v.y));
    }
 	return p;    
}

float map1(in vec3 p) // object
{     
    p.yz *= rotate(0.2 * sin(iGlobalTime * 0.3) + 0.1);
    p.zx *= rotate(0.7 * sin(iGlobalTime * 0.5));
    p.x  += 0.2 * cos(iGlobalTime);
    p.y  += 0.1 * sin(iGlobalTime);
    // wings
    vec3 f = p;
    f.y -= -0.3;
    f.zx = fold2(f.zx, PI / 4.0 + 0.3 * sin(iGlobalTime * 5.0));
    if(abs(atan(p.z, p.x)) < 0.1) f.z += 1.0;
    float de1 = 0.8 * max(abs(f.z) - 0.01, 3.0 * f.y * f.y + 0.5 * f.x - 0.6);
    // body
    vec2 p2d = vec2(length(p.xz), p.y); 
    float de2 = 0.5 * max(abs(p.y) - 2.3, abs(sin(p2d.y)) * sin(p2d.y - 1.2) - 0.25 + p2d.x);
    // sunglasse
    vec3 q = p;
    q.x -= 0.6;
    q.y -= 0.7;
    q.z = abs(q.z)-0.15;
    float de3 = max(abs(q.x)-0.001, length(q.yz) - 0.1);
    // star
    q = p;
    q.x -= 1.5;
    q.zy *= rotate(PI/5.0);
    q.zy = fold3(q.zy,  PI /5.0);
    q.y -= 0.2;
    q.y -= q.z*0.5;
    q.x = abs(q.x) + q.y*0.8;
    float de4 = 0.5 * ((q.y > 0.0) ? length(q.yx) : (abs(q.x) - 0.001));
    if (Flag)
    {
        if (de1 < de2 && de1 < de3 && de1 < de4 )
        {
            objCol = vec3(1.0, 0.0, 0.0); // wings
         } else if (de2 < de3 && de2 < de4 ){
            objCol = vec3(1.0); // body
         } else if (de3 < de4 ){
            objCol = vec3(0.0,0.0,0.3); // sunglasse
        } else {
            objCol = vec3(1.0, 1.0, 0.0); // star
        }
    }    
    return  min(min(min(de1, de2), de3), de4);
}

float map2(in vec3 p) //ground
{     
    p.zx = fold3(p.zx, PI / 5.0);
    p.x -= 3.0;
    p.x = abs(p.x) - 1.0;
    p.y += 0.15 * sin(length(p.zx) * 3.0);
	return dot(p, vec3(0.0, 1.0, 0.0)) + 8.0;
}

float map3(in vec3 p) // pole
{     
	return length(p.xz) - 0.3;
}

float map4(in vec3 p) // steps
{     
	p.xz *= rotate(iGlobalTime * 0.6);
    p.zx = vec2(length(p.zx) - 1.5, sin(atan(p.z, p.x)*0.5 + floor(p.y * 5.0) / 5.0));
    p.y = mod(p.y, 0.2)  -0.1;
    return  0.8 * udRoundBox(p, vec3(0.08, 0.03, 1.0), 0.02);
 }

float map(in vec3 p)
{
    float de1 = map1(p);
    p.z = abs(p.z - 3.5) - 12.0;
    p.zx = abs(p.zx - 3.0) - 8.0;
    float de2 = map2(p);
    float de3 = map3(p);
    float de4 = map4(p);    
    if (Flag)
    {
        if (de1 < de2 && de1 < de3 && de1 < de4)
        {
            material = 1;
         } else if (de2 < de3 && de2 < de4){
            material = 2;
         } else if (de3 < de4){
            material = 3;   
        } else {
            material = 4;
        }
    }    
    return min(min(min(de1,de2),de3),de4);
}

vec3 doColor(in vec3 p)
{
    Flag = true; map(p); Flag = false;
    if (material == 1) // object
    {
        return objCol;
    }
    if (material == 2) // ground
    {
        return mix(hsv(0.05, 0.6, 1.0 ),texture2D(iChannel1, p.zx * 0.05).xxx, 0.5);
    }
    if (material == 3) // pole
    {
        return hsv(atan(p.z, p.x) / PI - 0.02 * iGlobalTime, 0.7, 0.7);
    }
    return vec3(1.0, 0.3, 0.1); // steps
}

vec3 sky(in vec3 p)
{
    vec3 col = vec3(0.1, 0.15, 0.6) + 0.2 * pow(max(0.0, 0.5 - 3.0 * p.y), 3.0);
    float f = smoothstep(0.45, 1.0, boxmap(iChannel0, p * 2.5, p).x);
    return mix(col, vec3(0.8), clamp (f * (p.y + 0.2) * 5.0, 0.0, 1.0));      
}

vec3 calcNormal(in vec3 p)
{
	const vec2 e = vec2(0.0001, 0.0);
	return normalize(vec3(
		map(p + e.xyy) - map(p - e.xyy),
		map(p + e.yxy) - map(p - e.yxy),
		map(p + e.yyx) - map(p - e.yyx)));
}

float softshadow(in vec3 ro, in vec3 rd)
{
	float res = 1.0;
    float t = 0.05;
    for(int i = 0; i < 32; i++)
    {
		float h = map(ro + rd * t);
        res = min(res, 8.0 * h / t);
        t += clamp(h, 0.02, 0.1);
        if(h < 0.001 || t > 1.5) break;
    }
    return clamp(res, 0.0, 1.0);
}

float march(in vec3 ro, in vec3 rd)
{
	const float maxd = 50.0;
	const float precis = 0.001;
    float h = precis * 2.0;
    float t = 0.0;
	float res = -1.0;
    for(int i = 0; i < 64; i++)
    {
        if(h < precis || t > maxd) break;
	    h = map(ro + rd * t);
        t += h;
    }
    if(t < maxd) res = t;
    return res;
}

void main(void)
{
	vec2 p2d = (2.0 * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
   	vec3 ta = vec3(0.5);
    vec3 ro = vec3(5.0, 1.8, 2.0);
    float time = mod(iGlobalTime, 30.0);
    ro.xz *= rotate(-0.4 * PI * smoothstep(0.0, 15.0, time) + iGlobalTime * 0.01);
    ro.y  += 2.0 * smoothstep(5.0, 20.0, time);
    ro.xz += 18.0 * step(19.0, time);
    ro.xz += -20.0 * smoothstep(20.0, 28.0, time);
	vec3 cw = normalize(ta - ro);
	vec3 cp = vec3(0.0, 1.0, 0.0);
	vec3 cu = normalize(cross(cw, cp));
	vec3 cv = normalize(cross(cu, cw));
	vec3 rd = normalize(p2d.x * cu + p2d.y * cv + 2.5 * cw);
    vec3 li = normalize(vec3(1.0, 0.8, 1.0));
    vec3 col = sky(rd);
    float t = march(ro, rd);
    if(t > -0.001)
    {
        vec3 p3d = ro + t * rd;
        vec3 n = calcNormal(p3d);
		float dif = clamp((dot(n, li) + 0.5) * 0.7, 0.4, 1.0);
        dif *= clamp(softshadow(p3d, li), 0.4, 1.0);
   		col = doColor(p3d) * dif;
    }
    col = pow(col, vec3(0.7));
   	gl_FragColor = vec4(col, 1.0);
}
